﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using InfoWorld.HL7.ITS;

namespace BMS.Facade.Data
{
    /// <summary>
    /// Icon Info class used for icons listing.
    /// </summary>
    public class IconInfo
    {
        public static Dictionary<int, byte[]> IconBytes;
        static IconInfo()
        {
            IconBytes = new Dictionary<int, byte[]>();
        }

        #region Public Members

        /// <summary>
        /// Gets or sets the icon id.
        /// </summary>
        /// <value>
        /// The icon id.
        /// </value>
        public int IconId { get; set; }

        /// <summary>
        /// Gets or sets the group.
        /// </summary>
        /// <value>
        /// The group.
        /// </value>
        public string Group { get; set; }

        /// <summary>
        /// Gets or sets the subgroup.
        /// </summary>
        /// <value>
        /// The subgroup.
        /// </value>
        public string Subgroup { get; set; }

        /// <summary>
        /// Gets or sets the image bytes.
        /// </summary>
        /// <value>
        /// The image bytes.
        /// </value>
        public string ImageBytes { get; set; }

        /// <summary>
        /// Gets or sets the image bytes inactive.
        /// </summary>
        /// <value>
        /// The image bytes inactive.
        /// </value>
        public string ImageBytesInactive { get; set; }

        /// <summary>
        /// Gets or sets the icon description.
        /// </summary>
        /// <value>
        /// The icon description.
        /// </value>
        public string IconDescription { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this <see cref="IconInfo"/> is active.
        /// </summary>
        /// <value>
        ///   <c>true</c> if active; otherwise, <c>false</c>.
        /// </value>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the index of the order.
        /// </summary>
        /// <value>
        /// The index of the order.
        /// </value>
        public int OrderIndex { get; set; }

        /// <summary>
        /// Gets or sets the patient or room bed.
        /// </summary>
        /// <value>
        /// The patient or room bed.
        /// </value>
        public char? PatientOrRoomBed { get; set; }

        /// <summary>
        /// Gets or sets the name of the icon.
        /// </summary>
        /// <value>
        /// The name of the icon.
        /// </value>
        public string IconName { get; set; }

        /// <summary>
        /// Gets or sets the mouse over text.
        /// </summary>
        /// <value>
        /// The mouse over text.
        /// </value>
        public string MouseOverText { get; set; }

        /// <summary>
        /// Gets or sets the auto icon pattern.
        /// </summary>
        /// <value>
        /// The auto icon pattern.
        /// </value>
        public string AutoIconPattern { get; set; }

        /// <summary>
        /// Gets or sets the auto icon active.
        /// </summary>
        /// <value>
        /// The auto icon active.
        /// </value>
        public bool AutoIconActive { get; set; }

        /// <summary>
        /// Gets or sets the is isolation.
        /// </summary>
        /// <value>
        /// The is isolation.
        /// </value>
        public bool IsIsolation { get; set; }

        /// <summary>
        /// Gets or sets the facility.
        /// </summary>
        /// <value>
        /// The facility.
        /// </value>
        public Place Facility { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is association.
        /// </summary>
        /// <value>
        /// 	<c>true</c> if this instance is association; otherwise, <c>false</c>.
        /// </value>
        public bool IsAssociation { get; set; }

        /// <summary>
        /// Gets or sets the type of the icon.
        /// </summary>
        /// <value>
        /// The type of the icon.
        /// </value>
        public CD IconType { get; set; }

        /// <summary>
        /// Gets or sets the published.
        /// </summary>
        /// <value>
        /// The published.
        /// </value>
        public bool? Published { get; set; }

        /// <summary>
        /// Gets or sets the name of the image.
        /// </summary>
        /// <value>
        /// The name of the image.
        /// </value>
        public string ImageName { get; set; }

        #endregion

        public static byte[] SameSimilarNameIcon { get; set; }

        public static byte[] BedInIsolationIcon { get; set; }
    }
}
